function guiWithTwoPushbuttonsii
% guiWithTwoPushbuttonsii has two pushbuttons
%   but just one callback function
% Format: guiWithTwoPushbuttonsii
  
% Create the GUI but make it invisible for now while 
%  it is being initialized
f = figure('Visible', 'off','color','white','Units',...
    'Normalized', 'Position', [.25 .5 .4 .2]);
f.Name = 'GUI with 2 pushbuttons';
movegui(f,'center')
 
% Create a pushbutton that says "Push me!!"
hbutton1 = uicontrol('Style','pushbutton','String',...
    'Push me!!', 'Units', 'Normalized',...
    'Position',[.3 .6 .4 .2], ...
    'Callback',@callbackfn);
 
% Create a pushbutton that says "No, Push me!!"
hbutton2 = uicontrol('Style','pushbutton','String',...
    'No, Push me!!', 'Units', 'Normalized',...
    'Position',[.3 .3 .4 .2], ...
    'Callback',@callbackfn);
% Now the GUI is made visible
f.Visible = 'on';
 
    % Call back function for both buttons
    function callbackfn(hObject,~)
       % callbackfn is called by the 'Callback' property
      
        set([hbutton1 hbutton2],'Visible','off');
        hstr = uicontrol('Style','text',...
            'BackgroundColor', 'white', 'Units',...
            'Normalized','Position',[.4 .5 .2 .2],...
            'FontSize',30);
        if hObject == hbutton1
            hstr.String = '!!!!!';
            hstr.ForegroundColor = 'Red';
        else
            hstr.String = '*****';
            hstr.ForegroundColor = 'Blue';
        end
        hstr.Visible = 'on';
    end
 
end
